function Tokyo = importfile(filename, dataLines)
%IMPORTFILE テキスト ファイルからデータをインポート
%  TOKYO = IMPORTFILE(FILENAME) は既定の選択に関してテキスト ファイル FILENAME
%  からデータを読み取ります。  データを table として返します。
%
%  TOKYO = IMPORTFILE(FILE, DATALINES) はテキスト ファイル FILENAME
%  の指定された行区間のデータを読み取ります。DATALINES
%  を正の整数スカラーとして指定するか、行区間が不連続の場合は正の整数スカラーからなる N 行 2 列の配列として指定します。
%
%  例:
%  Tokyo = importfile("C:\Users\data\20020901_Tokyo.csv", [7, Inf]);
%
%  READTABLE も参照してください。
%
% MATLAB からの自動生成日: 2021年 10月 5日 15:38:17

%% 入力の取り扱い

% dataLines が指定されていない場合、既定値を定義します
if nargin < 2
    dataLines = [7, Inf];
end

%% インポート オプションの設定およびデータのインポート
opts = delimitedTextImportOptions("NumVariables", 4);

% 範囲と区切り記号の指定
opts.DataLines = dataLines;
opts.Delimiter = ",";

% 列名と型の指定
opts.VariableNames = ["Time", "Rainfall", "Var3", "Temperature"];
opts.SelectedVariableNames = ["Time", "Rainfall", "Temperature"];
opts.VariableTypes = ["datetime", "double", "string", "double"];

% ファイル レベルのプロパティを指定
opts.ExtraColumnsRule = "ignore";
opts.EmptyLineRule = "read";

% 変数プロパティを指定
opts = setvaropts(opts, "Var3", "WhitespaceRule", "preserve");
opts = setvaropts(opts, "Var3", "EmptyFieldRule", "auto");
opts = setvaropts(opts, "Time", "InputFormat", "yyyy/MM/dd HH:mm:ss");

% データのインポート
Tokyo = readtable(filename, opts);

end